//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    day: Joi.string().required(),
    reward: Joi.number().required(),
  };
  console.log(0);

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    console.log(1);
    const day = req.body.day;
    const reward = req.body.reward;

    //

    //
    const data = {
      day,
      reward,
    };
    console.log(2, data);
    const getdailyRewardByday = await prisma.dailyReward.findFirst({
      where: { day: day },
    });

    console.log(3);
    if (getdailyRewardByday)
      res.status(404).send("جایزه روزانه قبلا ثبت شده است");
    else {
      const newdailyReward = await prisma.dailyReward.create({
        data: data,
      });
      console.log(4);
      res.status(201).json(newdailyReward);
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deleted = await prisma.dailyReward.delete({
      where: {
        id: req.body.id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deleted);
    res.status(200).json({ deleted });
  }
};

const getAll = async (req, res) => {
  const dailyRewards = await prisma.dailyReward
    .findMany
    // {
    // include: {
    //   posts: true,
    //   profile: true,
    // },  }
    ();
  res.status(200).json({ dailyRewards: dailyRewards });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const getdailyRewardById = await prisma.dailyReward.findUnique({
      where: { id: req.body.id },
    });

    res.status(200).json({ getdailyRewardById });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
    day: Joi.string().required(),
    reward: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const id = parseInt(req.body.id);
    const day = req.body.day;
    const reward = req.body.reward;
    const updateddailyRewardData = {
      day,
      reward,
    };
    console.log(0, updateddailyRewardData);
    const existingdailyReward = await prisma.dailyReward.findUnique({
      where: { id: id }, // Check if a profile exists with the user ID
    });

    console.log(0, existingdailyReward);

    if (existingdailyReward) {
      console.log(1);
      const updateddailyReward = await prisma.dailyReward.update({
        where: { id: id }, // Update the existing profile with the user ID
        data: updateddailyRewardData, // Update specific fields
      });
      res.status(201).json(updateddailyReward);
    } else {
      res.status(400).json({ error: "user not found" });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,
};
