//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    name: Joi.string().required(),
    position: Joi.string().required(),
  };
  console.log(0);

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    console.log(1);
    const name = req.body.name;
    const position = req.body.position;

    //

    //
    const data = {
      name,
      position,
    };
    console.log(2, data);
    const getFormationByName = await prisma.formation.findFirst({
      where: { name: name },
    });

    console.log(3);
    if (getFormationByName) res.status(404).send("ترکیب قبلا ثبت شده است");
    else {
      const newFormation = await prisma.formation.create({
        data: data,
      });
      console.log(4);
      res.status(201).json(newFormation);
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deleted = await prisma.formation.delete({
      where: {
        id: req.body.id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deleted);
    res.status(200).json({ deleted });
  }
};

const getAll = async (req, res) => {
  const formations = await prisma.formation
    .findMany
    // {
    // include: {
    //   posts: true,
    //   profile: true,
    // },  }
    ();
  res.status(200).json({ formations: formations });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const getFormationById = await prisma.formation.findUnique({
      where: { id: req.body.id },
    });

    res.status(200).json({ getFormationById });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
    name: Joi.string().required(),
    position: Joi.string().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const id = parseInt(req.body.id);
    const name = req.body.name;
    const position = req.body.position;
    const updatedFormationData = {
      name,
      position,
    };
    console.log(0, updatedFormationData);
    const existingFormation = await prisma.formation.findUnique({
      where: { id: id }, // Check if a profile exists with the user ID
    });

    console.log(0, existingFormation);

    if (existingFormation) {
      console.log(1);
      const updatedFormation = await prisma.formation.update({
        where: { id: id }, // Update the existing profile with the user ID
        data: updatedFormationData, // Update specific fields
      });
      res.status(201).json(updatedFormation);
    } else {
      res.status(400).json({ error: "user not found" });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,
};
