//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const { join } = require("@prisma/client/runtime/library");
const { update } = require("./playerController");
const prisma = new PrismaClient();
//

///
const updatePoint = async (userId, points) => {
  // check user's leage : 1) no leage 2) expired leage 3) has leage
  console.log("starrt updatind poitn of user ", userId, points);
  const thisUser = await prisma.profile.findFirst({
    where: { userId: userId },
    include: {
      leage: true,
    },
  });
  console.log("profile :", thisUser);
  const sevenDaysAgo = new Date();
  sevenDaysAgo.setDate(sevenDaysAgo.getDate() - 7);
  if (!thisUser.leage) {
    // no leage
    joinLeage(userId, points, thisUser.level);
  } else if (thisUser.leage.status == "expired") {
    // expired before
    joinLeage(userId, points, thisUser.level);
  } else if (new Date(thisUser.leage.createdAt) < sevenDaysAgo) {
    // has to set expired
    doneLeage(thisUser.leage);

    joinLeage(userId, points, thisUser.level);
  } else {
    updateRanking(userId, points, thisUser.leage);
  }
};

const joinLeage = async (userId, points, level) => {
  // find a leage with less than max player in this level
  console.log("joint a leage!", level);
  const baseLeage = await prisma.leageBase.findFirst({
    where: { level: level },
  });
  console.log("base leage is ", baseLeage);
  const thisLeage = await prisma.leage.findFirst({
    where: {
      leageBaseId: baseLeage.id,
      players: {
        every: {
          // Access the player model fields here
          id: {
            // Replace with actual player field for filtering
            lt: 30, // Filter based on a specific field
          },
        },
      },
      createdAt: {
        gte: new Date(new Date().setDate(new Date().getDate() - 5)),
      },
    },
  });

  if (thisLeage) {
    console.log("find a leage :", thisLeage);
    const updatedLeague = await prisma.leage.update({
      where: {
        id: thisLeage.id,
      },
      data: {
        points: [...thisLeage.points, { userId: userId, points: points }],
      },
    });
    const updatedProfile = await updateProfile(userId, thisLeage.id);
    console.log("updated leage :", updatedLeague);
  } else {
    console.log("create new leage:");
    const baseLeage = await prisma.LeageBase.findFirst({
      where: { level: level },
    });
    console.log("base leage :", baseLeage);
    // const thisProfile = await prisma.profile.findFirst({
    //   where: { userId: userId },
    // });
    const data = {
      leageBaseId: baseLeage.id,
      points: [{ userId: userId, points: points }],
    };
    const newLeage = await prisma.leage.create({ data: data });
    console.log("new leage :", newLeage);
    const updatedProfile = await updateProfile(userId, newLeage.id);

    console.log("updated profile:", updatedProfile);
  }
};

const doneLeage = async (thisLeage) => {
  console.log("done leage!");
  const sortedData = thisLeage.points.sort((a, b) => b.points - a.points);

  // Create uplist and downlist
  const uplist = sortedData.slice(0, 3);
  const downlist = sortedData.slice(25);
  const base = await prisma.leageBase.findFirst({
    where: { id: thisLeage.leageBaseId },
  });

  console.log("list is :", thisLeage, uplist, downlist, base.level);
  for (const element of uplist) {
    //upgrade levels
    await prisma.profile.update({
      where: { userId: element.userId },
      data: { level: base.level + 1 },
    });
  }
  if (base.level > 0) {
    for (const element of downlist) {
      //upgrade levels
      await prisma.profile.update({
        where: { userId: element.userId },
        data: { level: base.level - 1 },
      });
    }
  }
  await prisma.leage.update({
    where: { id: thisLeage.id },
    data: { status: "over" },
  });

  console.log("upgarede list is done!");

  // first rank the players
  // 2nd add upgrade top 3 players
  // downgrade 6 players
  const points = thisLeage.points;
};

const updateRanking = async (userId, points, leage) => {
  console.log("updating ranks:", leage);
  console.log("points ::", leage.players);
  const newPoint = leage.points.map((point) => {
    if (point.userId == userId) {
      console.log("point is :", point);
      return { ...point, points: point.points + points };
    } else {
      console.log("not equal point :", point, userId);
      return point;
    }
  });
  console.log("newList is :", newPoint);
  const updatedLeague = await prisma.leage.update({
    where: {
      id: leage.id,
    },
    data: {
      points: newPoint,
    },
  });
  console.log("updated leage :", updatedLeague);
};

const updateProfile = async (userId, leageId) => {
  const updatedProfile = await prisma.profile.update({
    where: {
      userId: userId,
    },
    data: {
      leageId: leageId, // Replace newLeageId with the actual ID you want to set
    },
  });
  return updatedProfile;
};

///
const testUpdate = async (req, res) => {
  const schema = {
    points: Joi.number().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    const points = req.body.points;
    const userId = req.userData.id;
    await updatePoint(userId, points);
    res.status(200).send("done");
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

/// global league:
const top10 = async (req, res) => {
  try {
    const userId = req.userData.id;

    const topTenProfiles = await prisma.profile.findMany({
      orderBy: {
        points: "desc",
      },
      take: 10,
    });
    const topTenUserIds = topTenProfiles.map((profile) => profile.userId);
    const userRewards = await prisma.userReward.findMany({
      where: {
        userId: {
          in: topTenUserIds,
        },
      },
    });
    // Create a map for quick lookup of userRewards by userId
    const userRewardsMap = new Map();
    userRewards.forEach((reward) => {
      userRewardsMap.set(reward.userId, reward);
    });

    // Merge the lists
    let currentRank = 1;
    let previousPoints = null;
    let sameRankCount = 0;

    const mergedList = topTenProfiles.map((profile, index) => {
      const reward = userRewardsMap.get(profile.userId) || {};

      if (previousPoints !== null && profile.points === previousPoints) {
        sameRankCount++;
      } else {
        currentRank += sameRankCount;
        sameRankCount = 1;
      }
      return {
        rank: currentRank,
        userId: profile.userId,
        win: reward.win || 0,
        lose: reward.loose || 0,
        game: (reward.win || 0) + (reward.loose || 0),
        point: profile.points,
        balance: profile.balance,
        name: profile.team,
        logo: profile.logoUrl,
      };
    });

    const userExists = mergedList.some((profile) => profile.userId === userId);

    if (userExists) {
      userRank = getRank(userId);
      mergedList.push(userRank);
    }

    res.status(200).json({ list: mergedList });
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

const getRank = async (userId) => {
  const playerProfile = await prisma.profile.findUnique({
    where: { userId: userId },
  });

  const userRewards = await prisma.userReward.findUnique({
    where: { userId: userId },
  });

  if (userRewards) {
    const playerPoints = playerProfile.points;

    const rank = await prisma.profile.count({
      where: {
        points: {
          gt: playerPoints,
        },
      },
    });

    const data = {
      userId: playerProfile.userId,
      win: userRewards.win || 0,
      lose: userRewards.loose || 0,
      game: (userRewards.win || 0) + (userRewards.loose || 0),
      point: playerProfile.points,
      balance: playerProfile.balance,
      name: playerProfile.team,
      logo: playerProfile.logoUrl,
    };
    console.log(`The rank of the player with userId ${userId} is ${rank + 1}`);
    console.log("Data:", data);
    retrun({ rank: rank + 1, ...data });
  } else {
    const data = {
      userId: userId,
      win: 0,
      lose: 0,
      game: 0,
      point: playerProfile.points,
      balance: playerProfile.balance,
      name: playerProfile.team,
      logo: playerProfile.logoUrl,
    };
    retrun({ rank: -1, ...data });
  }
};

const myRank = async (req, res) => {
  try {
    const userId = req.userData.id;

    const playerProfile = await prisma.profile.findUnique({
      where: { userId: userId },
    });

    const userRewards = await prisma.userReward.findUnique({
      where: { userId: userId },
    });

    if (playerProfile && userRewards) {
      const playerPoints = playerProfile.points;

      const rank = await prisma.profile.count({
        where: {
          points: {
            gt: playerPoints,
          },
        },
      });

      const data = {
        userId: playerProfile.userId,
        win: userRewards.win || 0,
        lose: userRewards.loose || 0,
        game: (userRewards.win || 0) + (userRewards.loose || 0),
        point: playerProfile.points,
        balance: playerProfile.balance,
        name: playerProfile.team,
        logo: playerProfile.logoUrl,
      };
      console.log(
        `The rank of the player with userId ${userId} is ${rank + 1}`
      );
      console.log("Data:", data);
      res.status(200).json({ rank: rank + 1, data: data });
    } else {
      console.log(`No profile found for userId ${userId}`);
      res.status(400).send("no profile setted to tis user id");
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

const getWeeklyLeague = async (req, res) => {
  try {
    const userId = req.userData.id;

    const playerProfile = await prisma.profile.findUnique({
      where: { userId: userId },
      // select: { points: true },
    });
    console.log("\n\n\n\n weekly leage:", playerProfile);

    const userLeage = await prisma.leage.findUnique({
      where: { id: playerProfile.leageId },
    });

    const thisUsersId = userLeage.points.map((point) => point.userId);
    const profiles = await prisma.userReward.findMany({
      where: {
        userId: {
          in: thisUsersId,
        },
      },
    });

    const newPoints = userLeage.points.map((point) => ({
      ...point,
      profile: profiles.find((profile) => profile.userId === point.userId),
    }));

    const sortedList = newPoints.sort((a, b) => b.points - a.points);

    const newList = { ...userLeage, points: sortedList };

    if (userLeage) {
      res.status(200).json({ league: newList, profiles: profiles });
    } else {
      console.log(`No profile found for userId ${userId}`);
      res.status(400).send("no leage setted to this user id");
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

module.exports = {
  updatePoint,
  testUpdate,
  top10,
  myRank,
  getWeeklyLeague,
};
