const express = require("express");
const app = express();
const port = 8080;
const pool = require("./mysqlDatabase");
const axios = require("axios");
const bodyParser = require("body-parser");
//
const fs = require("fs");
const path = require("path");
const http = require("http");
const https = require("https");
//socket :
const WebSocket = require("ws");
const jwt = require("jsonwebtoken");
require("dotenv").config();
//rtc
const webrtcAdapter = require("webrtc-adapter");

////////
const userRoute = require("./routes/user/userRoute");
const playerRoute = require("./routes/playerRoute");
const cartRoute = require("./routes/cartRoute");
const teamRoute = require("./routes/teamRoute");
const playRoute = require("./routes/playRoute");
const productRoute = require("./routes/productRoute");
const userRewardRoute = require("./routes/user/userRewardRoute");
const dailyRewardRoute = require("./routes/dailyRewardRoute");
const testLeage = require("./routes/testLeag");

const cors = require("cors");
app.use(express.json());
app.use(
  cors({
    origin: "*", // You can specify the allowed origins here
    methods: ["GET", "POST", "PUT", "DELETE"],
    allowedHeaders: ["Content-Type", "Authorization"],
  })
);
app.use(bodyParser.json({ limit: "50mb" }));
app.use(bodyParser.urlencoded({ limit: "50mb", extended: true }));

app.use(express.static("public"));
app.use("/backend/uploads", express.static("./public/uploads"));
app.use("/backend/userUploads", express.static("./public/userUploads"));

app.use("/backend/api/user", userRoute);
app.use("/backend/api/player", playerRoute);
app.use("/backend/api/cart", cartRoute);
app.use("/backend/api/team", teamRoute);
app.use("/backend/api/myreward", userRewardRoute);
app.use("/backend/api/play", playRoute);
app.use("/backend/api/product", productRoute);
app.use("/backend/api/reward", dailyRewardRoute);
app.use("/backend/api/league", testLeage);

// app.use("/backend/api/residency", residency);
//
app.get("/save-images", (req, res) => {
  const apiUrl = "https://toopchishop.com/wp-json/Api/v2/player"; // Replace with your API endpoint

  https
    .get(apiUrl, (apiRes) => {
      let data = "";

      apiRes.on("data", (chunk) => {
        data += chunk;
      });

      apiRes.on("end", () => {
        const jsonData = JSON.parse(data);

        jsonData.forEach((item) => {
          if (item.Card) {
            const url = item.Card;
            const protocol = url.startsWith("https") ? https : http;

            protocol
              .get(url, (response) => {
                const filePath = path.resolve(
                  __dirname,
                  "assets/cards",
                  `${item.Id}.webp`
                );
                const writer = fs.createWriteStream(filePath);

                response.pipe(writer);

                writer.on("finish", () => {
                  console.log(
                    `Image ${item.Id}.webp downloaded and saved successfully`
                  );
                });

                writer.on("error", (error) => {
                  console.error("Error writing file:", error);
                });
              })
              .on("error", (error) => {
                console.error("Error downloading image:", error);
              });
          }
        });

        res.status(200).send("Images are being downloaded and saved");
      });
    })
    .on("error", (error) => {
      console.error("Error fetching JSON data:", error);
      res.status(500).send("Error fetching JSON data");
    });
});

//
const server = app.listen(port, () => {
  console.log(`🌍 Server listening on port ${port} `);
});

const wss = new WebSocket.Server({ server });
const onlineUsers = new Map();

wss.on("connection", (ws, req) => {
  const token = req.url.split("token=")[1];

  console.log("new client: ", token);
  if (!token) {
    ws.close(4001, "Unauthorized");
    console.log("!token", token);
    return;
  }

  jwt.verify(token, process.env.SECRET_KEY, (err, decoded) => {
    if (err) {
      ws.close(4001, "Unauthorized");
      console.log("verify ", err, decoded);
      return;
    }

    console.log(decoded);
    onlineUsers.set(decoded.id, ws);

    ws.send(
      JSON.stringify({
        type: "onlineUsers",
        users: Array.from(onlineUsers.keys()),
      })
    );

    ws.on("message2", (message) => {
      try {
        console.log(message);

        const parsedMessage = JSON.parse(message);
        const { type, recipientId, content } = parsedMessage;
        console.log(parsedMessage, "from :", decoded.id);
        switch (type) {
          case "message":
            const recipientWs = onlineUsers.get(parseInt(recipientId));
            if (recipientWs && recipientWs.readyState === WebSocket.OPEN) {
              recipientWs.send(JSON.stringify({ from: decoded.id, content }));
              console.log("sendeing data :", { from: decoded.id, content });
            } else {
              console.log(
                recipientWs,
                recipientWs ? recipientWs.readyState : "dead@",
                recipientId
              );
            }
            break;
          case "playRequest":
            // Handle play request
            break;
          case "playResponse":
            // Handle play response
            break;
          case "gameData":
            // Handle game data
            break;
        }
      } catch (error) {
        console.log(error);
      }
    });

    ws.on("message", (message) => {
      const data = JSON.parse(message);

      switch (data.type) {
        case "registerPeer":
          // Handle peer registration

          // onlineUsers.set(data.peerId, ws);
          console.log(data.peerId, onlineUsers.size);
          console.log("Peer registered:", data.peerId);
          break;
        case "offer":
          // Handle offer
          const recipient = onlineUsers.get(data.recipientId);
          if (recipient) {
            recipient.send(
              JSON.stringify({ type: "offer", offer: data.offer })
            );
          }
          break;
        case "connectToPeer":
          // Handle offer
          const recipient2 = onlineUsers.get(data.recipientId);
          if (recipient2) {
            recipient2.send(
              JSON.stringify({ type: "offer", offer: data.offer, data: data })
            );
          }
          break;
        case "answer":
          // Handle answer
          const receiver = onlineUsers.get(data.recipientId);
          if (receiver) {
            receiver.send(
              JSON.stringify({ type: "answer", answer: data.answer })
            );
          }
          break;
        case "iceCandidate":
          // Handle ICE candidate
          const target = onlineUsers.get(data.recipientId);
          if (target) {
            target.send(
              JSON.stringify({
                type: "iceCandidate",
                candidate: data.candidate,
              })
            );
          }
          break;
        case "dataChannelMessage":
          // Handle data channel message
          const targetUser = onlineUsers.get(data.recipientId);
          if (targetUser) {
            targetUser.send(
              JSON.stringify({
                type: "dataChannelMessage",
                message: data.message,
              })
            );
          }
          break;

        default:
          // Handle unknown message type
          console.error("Unknown message type:", data.type);
          break;
      }
    });

    ws.on("close", () => {
      console.log(`User ${decoded.id} disconnected`);
      onlineUsers.delete(decoded.id);
      // tell all user's about updated list!
      broadcastStatusChange(decoded.id, "offline");
    });

    broadcastStatusChange(decoded.id, "online");
    ws.userId = decoded.userId;
  });
  function broadcastStatusChange(userId, status) {
    onlineUsers.forEach((ws, id) => {
      if (ws.readyState === WebSocket.OPEN) {
        ws.send(
          JSON.stringify({
            type: "userStatus",
            userId,
            status,
          })
        );
      }
    });
  }
});
