-- AlterTable
ALTER TABLE `profile` ADD COLUMN `leageId` INTEGER NOT NULL DEFAULT 0,
    ADD COLUMN `level` INTEGER NOT NULL DEFAULT 0;

-- CreateTable
CREATE TABLE `LeageBase` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(191) NOT NULL,
    `level` INTEGER NOT NULL DEFAULT 0,
    `count` INTEGER NOT NULL DEFAULT 30,
    `upCound` INTEGER NOT NULL DEFAULT 3,
    `downCound` INTEGER NOT NULL DEFAULT 6,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,
    `reward` JSON NOT NULL,

    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `Leage` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `leageBaseId` INTEGER NOT NULL,
    `cost` INTEGER NOT NULL DEFAULT 400,
    `points` JSON NOT NULL,
    `status` VARCHAR(191) NOT NULL DEFAULT 'runing',
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- AddForeignKey
ALTER TABLE `Profile` ADD CONSTRAINT `Profile_leageId_fkey` FOREIGN KEY (`leageId`) REFERENCES `Leage`(`id`) ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `Leage` ADD CONSTRAINT `Leage_leageBaseId_fkey` FOREIGN KEY (`leageBaseId`) REFERENCES `LeageBase`(`id`) ON DELETE RESTRICT ON UPDATE CASCADE;
