const express = require("express");
const router = express.Router();
const cartController = require("../controllers/cartController");
const auth = require("../middelwares/auth");

router.post("/", auth, cartController.create);
router.get("/", auth, cartController.getAll);
router.post("/id", auth, cartController.read);
router.post("/update", auth, cartController.update);
router.post("/delete", auth, cartController._delete);

router.get("/mine", auth, cartController.getMineAll);
router.post("/mine", auth, cartController.register);
router.post("/mine/list", auth, cartController.list);
router.post("/mine/sell", auth, cartController.sell);

module.exports = router;
