const express = require("express");
const router = express.Router();
const palayerController = require("../controllers/playerController");
const auth = require("../middelwares/auth");
const upload = require("../middelwares/upload");

router.post("/", auth, upload.single("photo"), palayerController.create);
router.get("/", palayerController.getAll);
router.post("/read", auth, palayerController.read);
router.post("/update", auth, upload.single("photo"), palayerController.update);
router.post("/delete", auth, palayerController._delete);
router.post("/test", palayerController.createTest);

module.exports = router;
