const express = require("express");
const router = express.Router();
const userFortmationController = require("../controllers/user/userFortmationController");
const auth = require("../middelwares/auth");
const upload = require("../middelwares/upload");

router.post("/", auth, upload.single("photo"), userFortmationController.create);
router.get("/", auth, userFortmationController.getAll);
router.post("/read", auth, userFortmationController.read);
router.post(
  "/update",
  auth,
  upload.single("photo"),
  userFortmationController.update
);
router.post("/delete", auth, userFortmationController._delete);

module.exports = router;
